﻿namespace VIRP.EFR.BO
{
    public static class ANALYSIS_DETAIL_SORT
    {
        private const int TestNameStandardized = 4;
        private const int TestNameMassSpec = 6;
        private const int TestNameConcentration = 7;
        private const int TestNameCreatinine = 8;
        private const int TestNameRatioU235U238 = 9;

        public static string SortByLabResults(ANALYSIS_DETAIL ad)
        {
            string result = string.Empty;

            switch ((int)ad.STD_TEST_NAME_ID)
            {
                case TestNameCreatinine:
                    result = "2" + ad.ANALYTE_NAME;
                    break;
                case TestNameMassSpec:
                    result = "3" + ad.ANALYTE_NAME;
                    break;
                case TestNameStandardized:
                    result = "4" + ad.ANALYTE_NAME;
                    break;
                case TestNameConcentration:
                    result = "1" + ad.ANALYTE_NAME;
                    break;
                case TestNameRatioU235U238:
                    result = "3" + "Uranium" + "2";
                    break;
                default:
                    result = "9" + ad.ANALYTE_NAME;
                    break;
            }

            return result;
        }
    }
}
